//
//  DependentComponentPickerViewController.m
//  Pickers
//
//  Created by Robert Górczyński on 11-06-22.
//

#import "DependentComponentPickerViewController.h"


@implementation DependentComponentPickerViewController
@synthesize picker;

@synthesize stateZips; 
@synthesize states; 
@synthesize zips; 

- (IBAction) buttonPressed { 
    NSInteger stateRow = [picker selectedRowInComponent:kStateComponent]; 
    NSInteger zipRow = [picker selectedRowInComponent:kZipComponent]; 
	
    NSString *state = [self.states objectAtIndex:stateRow]; 
    NSString *zip = [self.zips objectAtIndex:zipRow]; 
	
    NSString *title = [[NSString alloc] initWithFormat: 
                       @"Wybrałeś kod pocztowy %@.", zip]; 
    NSString *message = [[NSString alloc] initWithFormat: 
                         @"%@ jest używany w stanie %@", zip, state]; 
	
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:title 
                                                    message:message 
                                                   delegate:nil 
                                          cancelButtonTitle:@"OK" 
                                          otherButtonTitles:nil]; 
    [alert show]; 
    [alert release]; 
    [title release]; 
    [message release]; 
} 

- (void)viewDidLoad { 
	
    NSBundle *bundle = [NSBundle mainBundle]; 
    NSString *plistPath = [bundle pathForResource: 
                           @"statedictionary" ofType:@"plist"]; 
	
    NSDictionary *dictionary = [[NSDictionary alloc] 
                                initWithContentsOfFile:plistPath]; 
    self.stateZips = dictionary; 
    [dictionary release]; 
	
    NSArray *components = [self.stateZips allKeys]; 
    NSArray *sorted = [components sortedArrayUsingSelector: 
                       @selector(compare:)]; 
    self.states = sorted; 
	
    NSString *selectedState = [self.states objectAtIndex:0]; 
    NSArray *array = [stateZips objectForKey:selectedState]; 
    self.zips = array; 
} 

- (void)didReceiveMemoryWarning {
    // Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
    
    // Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.picker = nil; 
    self.stateZips = nil; 
    self.states = nil; 
    self.zips = nil; 	
}


- (void)dealloc {
	[picker release]; 
    [stateZips release]; 
    [states release]; 
    [zips release]; 	
    [super dealloc];
}

#pragma mark - 
#pragma mark Metody źródła danych dla kontrolki Picker
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView { 
    return 2; 
} 

- (NSInteger)pickerView:(UIPickerView *)pickerView 
numberOfRowsInComponent:(NSInteger)component { 
    if (component == kStateComponent) 
        return [self.states count]; 
    return [self.zips count]; 
} 

#pragma mark Metody delegata kontrolki Picker
- (NSString *)pickerView:(UIPickerView *)pickerView 
			 titleForRow:(NSInteger)row 
			forComponent:(NSInteger)component { 
    if (component == kStateComponent) 
        return [self.states objectAtIndex:row]; 
    return [self.zips objectAtIndex:row]; 
} 

- (void)pickerView:(UIPickerView *)pickerView 
	  didSelectRow:(NSInteger)row 
       inComponent:(NSInteger)component { 
    if (component == kStateComponent) { 
        NSString *selectedState = [self.states objectAtIndex:row]; 
        NSArray *array = [stateZips objectForKey:selectedState]; 
        self.zips = array; 
        [picker selectRow:0 inComponent:kZipComponent animated:YES]; 
        [picker reloadComponent:kZipComponent]; 
    } 
}

- (CGFloat)pickerView:(UIPickerView *)pickerView 
    widthForComponent:(NSInteger)component { 
    if (component == kZipComponent) 
        return 90; 
    return 200; 
}

@end
